/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.ammobench;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCount;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCountType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import dev.toma.gunsrpg.util.math.WeightedRandom;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class WeightedRangeOutputCount
implements AmmoBenchOutputCount {
    private final WeightedRandom<Entry> weightedRandom;

    public WeightedRangeOutputCount(Entry[] values) {
        this.weightedRandom = new WeightedRandom<Entry>(Entry::getWeight, values);
    }

    @Override
    public int getCount(int count) {
        Entry entry = this.weightedRandom.getRandom();
        if (entry != null) {
            return entry.modifier.getCount(count);
        }
        return count;
    }

    @Override
    public AmmoBenchOutputCountType<?> getType() {
        return AmmoBenchOutputCountType.WEIGHTED;
    }

    private static final class Entry {
        private final int weight;
        private final AmmoBenchOutputCount modifier;

        public Entry(int weight, AmmoBenchOutputCount modifier) {
            this.weight = weight;
            this.modifier = modifier;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public static final class Serializer
    implements AmmoBenchOutputCountType.AmmoBenchOutputCountSerializer<WeightedRangeOutputCount> {
        @Override
        public WeightedRangeOutputCount parseJson(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            JsonArray entriesJson = JSONUtils.func_151214_t((JsonObject)object, (String)"entries");
            Entry[] entries = new Entry[entriesJson.size()];
            int i = 0;
            for (JsonElement entryElement : entriesJson) {
                JsonObject data = JsonHelper.asJsonObject(entryElement);
                int weight = JSONUtils.func_151208_a((JsonObject)data, (String)"weight", (int)1);
                Object modifier = AmmoBenchOutputCountType.parseJson((JsonElement)JSONUtils.func_152754_s((JsonObject)data, (String)"entry"));
                entries[i++] = new Entry(weight, (AmmoBenchOutputCount)modifier);
            }
            return new WeightedRangeOutputCount(entries);
        }

        @Override
        public void toNetwork(WeightedRangeOutputCount weightedRangeOutputCount, PacketBuffer buffer) {
            Entry[] entries = (Entry[])weightedRangeOutputCount.weightedRandom.getValues();
            buffer.writeInt(entries.length);
            for (Entry entry : entries) {
                buffer.writeInt(entry.weight);
                AmmoBenchOutputCountType.toNetwork(entry.modifier, buffer);
            }
        }

        @Override
        public WeightedRangeOutputCount fromNetwork(PacketBuffer buffer) {
            int count = buffer.readInt();
            Entry[] entries = new Entry[count];
            for (int i = 0; i < count; ++i) {
                entries[i] = new Entry(buffer.readInt(), (AmmoBenchOutputCount)AmmoBenchOutputCountType.fromNetwork(buffer));
            }
            return new WeightedRangeOutputCount(entries);
        }

        @Override
        public CompoundNBT toNbt(WeightedRangeOutputCount weightedRangeOutputCount) {
            Entry[] entries;
            CompoundNBT nbt = new CompoundNBT();
            ListNBT list = new ListNBT();
            for (Entry entry : entries = (Entry[])weightedRangeOutputCount.weightedRandom.getValues()) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a("weight", entry.weight);
                tag.func_218657_a("entry", (INBT)AmmoBenchOutputCountType.toNbt(entry.modifier));
                list.add((Object)tag);
            }
            nbt.func_218657_a("entries", (INBT)list);
            return nbt;
        }

        @Override
        public WeightedRangeOutputCount fromNbt(CompoundNBT nbt) {
            ListNBT entriesNbt = nbt.func_150295_c("entries", 10);
            Entry[] entries = new Entry[entriesNbt.size()];
            for (int i = 0; i < entriesNbt.size(); ++i) {
                CompoundNBT tag = entriesNbt.func_150305_b(i);
                entries[i] = new Entry(tag.func_74762_e("weight"), (AmmoBenchOutputCount)AmmoBenchOutputCountType.fromNbt(tag.func_74775_l("entry")));
            }
            return new WeightedRangeOutputCount(entries);
        }
    }
}

